jQuery(document).ready(function () {
	if(!estadoCierreRealizado && esUsuarioModificacion){
		$("#cierre_toolbar").rup_toolbar({
			buttons:
				[{id:"GuardarObservaciones", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true, click:guardarObservaciones}]
		});
		$("#ftramitacion028").rup_date({datetimepicker: false});
	}else{
		$("#observaciones028").attr("readonly", "readonly");
		$("#ftramitacion028").attr("readonly", "readonly");
	}
	
	$("#cierre_form").rup_validate({
		feedback:$("#tramitacion_feedback"),
		liveCheckingErrors: true,
		rules:{
			"ftramitacion028":{required:true,date:true}
		}
	});	
	
});	

//Funcion que serializa el Expediente para ser enviado
function serializeExpediente(){
	return $("#cierre_form").rup_form('formToJson');
}

function guardarObservaciones(){
	// Llamada ajax para Guardar
	var fechaTramitacion = $("#ftramitacion028").val();
	var idExpediente = $("#idProv024").val() + "/" + $("#idAno024").val() + "/" + $("#id024").val();
	if(ab03bUtils.form.validate($("#cierre_form"), $("#tramitacion_feedback"))){
		$.rup_ajax({
			url:  $.rup.CTX_PATH +"ab03b28t00/guardar",
			type: "POST",
			data: JSON.stringify(serializeExpediente()),
			dataType: 'json',
			contentType: 'application/json',
			success: function (mapaRespuesta){
				location.href = $.rup.CTX_PATH + "expedientesRERA/detalle/tramitacion/irTramite/" + idExpediente + "/" + $("#id028").val() +"/false?tab=0";;		
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#tramitacion_feedback"));
			},
			error: function(error){
				pintarFeedbackError(error.responseText, $("#tramitacion_feedback"));
			},
			beforeSend :  function() {
				ab03bUtils.util.bloquearInterfaz();
			},
			complete: function() {
				ab03bUtils.util.desBloquearInterfaz();
			}
		});
	}

}